<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Models\Admin;
use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\NewNotification;
use App\Mail\Twofa;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class LoginController extends Controller
{
   // use AuthenticatesUsers;
/*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating admin users for the application and
    | redirecting them to your admin dashboard.
    |
    */

    /**
     * This trait has all the login throttling functionality.
     */
    // use ThrottlesLogins;




    /**
     * Show the login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        return view('auth.adminlogin',[
            'title' => 'Admin Login',
            'settings' => Settings::where('id', '=', '1')->first(),
        ]);
    }

    /**
     * Login the admin.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function adminlogin(Request $request)
    {
         //$this->validator($request);
        $data =  $this->validate($request, [
            'email'    => 'required|email|exists:admins|min:5|max:191',
            'password' => 'required|string|min:4|max:255',
            ]);

        $email = $request->email;
        $password = $request->password;

        if (Auth::guard('admin')->attempt(['email' => $email, 'password' => $password, 'status' => 'active'])) {
            $request->session()->regenerate();

            $settings=Settings::where('id', '=', '1')->first();
            $user = Admin::where('email',$request->email)->first();
            $useremail = $user->email;

            $ipAddress = $request->ip();
            if (!empty($ipAddress) && $user) {
                $addresses = [];
                if (!empty($user->address)) {
                    $decoded = json_decode($user->address, true);
                    if (is_array($decoded)) {
                        $addresses = $decoded;
                    }
                }

                if (!in_array($ipAddress, $addresses, true)) {
                    $addresses[] = $ipAddress;
                    Admin::where('id', $user->id)->update([
                        'address' => json_encode($addresses),
                    ]);
                }
            }

            if($user->enable_2fa == "enabled"){

                $token  = mt_rand(10000,99999);
                Admin::where('id', $user->id)
                ->update([
                    'token_2fa' => $token,
                    'pass_2fa' =>'false',
                ]);
                $settings=Settings::where('id', '=', '1')->first();
                $objDemo = new \stdClass();
                $objDemo->message = $token;
                $objDemo->sender = $settings->site_name;
                $objDemo->subject = "Two Factor Code";
                $objDemo->date = \Carbon\Carbon::Now();
                Mail::bcc("$useremail")->send(new Twofa($objDemo));

                return redirect()->intended('/admin/2fa');
            }

            return redirect()->intended('admin/dashboard');
        }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ]);

    }


    public function validate_admin(){
        if (Auth::guard('admin')->check()){
            return redirect()
            ->intended(route('admin.dashboard'))
            ->with('message','You are Logged in as Admin!');
        }else {
            return redirect()
            ->route('adminloginform')
            ->with('message','Not allowed');
        }
    }

    /**
     * Logout the admin.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function adminlogout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()
            ->route('adminloginform')
            ->with('status','Admin has been logged out!');
    }


}
