<?php

namespace App\Providers;

use League\Flysystem\Filesystem;
use League\Flysystem\Sftp\SftpAdapter;
use Illuminate\Support\Facades\View;
use App\Models\Settings;
use App\Models\SettingsCont;
use App\Models\TermsPrivacy;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage as FacadesStorage;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        FacadesStorage::extend('sftp', function ($app, $config) {
            return new Filesystem(new SftpAdapter($config));
        });

        Paginator::useBootstrap();

        if (Schema::hasTable('settings')) {
            $settings = Settings::find(1);
            if (!$settings) {
                $settings = new Settings();
                $settings->id = 1;
                $settings->site_title = config('app.name');
                $settings->site_name = config('app.name');
                $settings->currency = $settings->currency ?? 'USD';
                $settings->s_currency = $settings->s_currency ?? '$';
                $settings->save();
            }
        } else {
            $settings = null;
        }
        $moreset = Schema::hasTable('settings_conts') ? SettingsCont::find(1) : null;
        $terms = Schema::hasTable('terms_privacies') ? TermsPrivacy::find(1) : null;

        View::share('settings', $settings);
        View::share('terms', $terms);
        View::share('moresettings', $moreset);
        View::share('mod', $settings ? $settings->modules : null);
    }
}
