<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('site_name', 191)->nullable();
            $table->text('description')->nullable();
            $table->string('currency', 191)->nullable();
            $table->string('s_currency', 191)->nullable();
            $table->string('capt_secret', 191)->nullable();
            $table->string('capt_sitekey', 191)->nullable();
            $table->string('payment_mode', 191)->nullable();
            $table->string('location', 191)->nullable();
            $table->string('s_s_k', 191)->nullable();
            $table->string('s_p_k', 191)->nullable();
            $table->string('pp_cs', 191)->nullable();
            $table->string('pp_ci', 191)->nullable();
            $table->string('keywords', 191)->nullable();
            $table->string('site_title', 191)->nullable();
            $table->string('site_address', 191)->nullable();
            $table->string('logo', 191)->nullable();
            $table->string('favicon', 191)->nullable();
            $table->string('trade_mode', 191)->nullable();
            $table->string('google_translate', 191)->nullable();
            $table->string('captcha', 191)->nullable();
            $table->string('contact_email', 191)->nullable();
            $table->string('weekend_trade', 191)->nullable();
            $table->string('timezone', 191)->nullable();
            $table->string('mail_server', 20)->nullable();
            $table->string('emailfrom', 191)->nullable();
            $table->string('emailfromname', 191)->nullable();
            $table->string('smtp_host', 191)->nullable();
            $table->string('smtp_port', 191)->nullable();
            $table->string('smtp_encrypt', 191)->nullable();
            $table->string('smtp_user', 191)->nullable();
            $table->string('smtp_password', 191)->nullable();
            $table->string('google_secret', 191)->nullable();
            $table->string('google_id', 191)->nullable();
            $table->string('google_redirect', 191)->nullable();
            $table->string('referral_commission', 191)->nullable();
            $table->string('referral_commission1', 191)->nullable();
            $table->string('referral_commission2', 191)->nullable();
            $table->string('referral_commission3', 191)->nullable();
            $table->string('referral_commission4', 191)->nullable();
            $table->string('referral_commission5', 191)->nullable();
            $table->string('signup_bonus', 191)->nullable();
            $table->integer('deposit_bonus')->nullable();
            $table->longText('tawk_to')->nullable();
            $table->string('enable_2fa', 191)->default('no');
            $table->string('enable_kyc', 191)->default('no');
            $table->string('enable_kyc_registration', 191)->nullable();
            $table->string('enable_with', 191)->nullable();
            $table->string('enable_verification', 191)->default('true');
            $table->string('enable_social_login', 191)->nullable();
            $table->string('withdrawal_option', 191)->default('auto');
            $table->string('deposit_option', 191)->nullable();
            $table->string('auto_merchant_option', 191)->default('Coinpayment');
            $table->string('dashboard_option', 191)->nullable();
            $table->string('enable_annoc', 191)->nullable();
            $table->text('subscription_service')->nullable();
            $table->boolean('return_capital')->default(true);
            $table->boolean('should_cancel_plan')->default(true);
            $table->string('commission_type', 191)->nullable();
            $table->string('commission_fee', 191)->nullable();
            $table->string('monthlyfee', 191)->nullable();
            $table->string('quarterlyfee', 191)->nullable();
            $table->string('yearlyfee', 191)->nullable();
            $table->string('newupdate', 191)->nullable();
            $table->longText('modules')->nullable()->collation('utf8mb4_bin');
            $table->string('redirect_url', 192)->nullable();
            $table->string('website_theme', 191)->default('purpose.css');
            $table->string('theme', 192)->nullable();
            $table->string('credit_card_provider', 191)->default('Paystack');
            $table->string('deduction_option', 191)->default('userRequest');
            $table->text('welcome_message')->nullable();
            $table->string('install_type', 20)->nullable();
            $table->string('merchant_key', 192)->nullable();
            $table->string('usertheme', 255)->default('dark');
            $table->string('tido', 255)->nullable();
            $table->string('whatsapp', 255)->nullable();
            $table->string('twak', 24)->nullable();
            $table->timestamps();
            $table->string('min_return', 255)->default('3000');
            $table->string('min_balance', 255)->default('30000');
            $table->integer('trading_winrate')->default(62);
            $table->string('wallet_status', 11)->default('on');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
