<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('copytradings')) {
            return;
        }

        Schema::table('copytradings', function (Blueprint $table) {
            // Add missing fields for the copy trading functionality
            if (!Schema::hasColumn('copytradings', 'photo')) {
                $table->string('photo')->nullable()->after('name'); // Trader photo
            }
            if (!Schema::hasColumn('copytradings', 'rating')) {
                $table->integer('rating')->default(5)->after('photo'); // Trader rating (1-5)
            }
            if (!Schema::hasColumn('copytradings', 'followers')) {
                $table->integer('followers')->default(0)->after('rating'); // Number of followers
            }
            if (!Schema::hasColumn('copytradings', 'equity')) {
                $table->decimal('equity', 8, 2)->default(0)->after('followers'); // Profit rate percentage
            }
            if (!Schema::hasColumn('copytradings', 'total_profit')) {
                $table->decimal('total_profit', 15, 2)->default(0)->after('equity'); // Total profit generated
            }
            if (!Schema::hasColumn('copytradings', 'status')) {
                $table->enum('status', ['active', 'inactive'])->default('active')->after('total_profit'); // Status
            }
            if (!Schema::hasColumn('copytradings', 'description')) {
                $table->text('description')->nullable()->after('status'); // Trader description
            }
            if (!Schema::hasColumn('copytradings', 'win_rate')) {
                $table->integer('win_rate')->default(80)->after('description'); // Win rate percentage
            }
            if (!Schema::hasColumn('copytradings', 'total_trades')) {
                $table->integer('total_trades')->default(0)->after('win_rate'); // Total number of trades
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (!Schema::hasTable('copytradings')) {
            return;
        }

        Schema::table('copytradings', function (Blueprint $table) {
            $columns = [
                'photo',
                'rating',
                'followers',
                'equity',
                'total_profit',
                'status',
                'description',
                'win_rate',
                'total_trades'
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('copytradings', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
