<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('user_copytradings')) {
            return;
        }

        Schema::table('user_copytradings', function (Blueprint $table) {
            // Add missing fields for profit tracking and management
            if (!Schema::hasColumn('user_copytradings', 'started_at')) {
                $table->timestamp('started_at')->nullable()->after('type'); // When copy trading started
            }
            if (!Schema::hasColumn('user_copytradings', 'last_profit')) {
                $table->timestamp('last_profit')->nullable()->after('started_at'); // Last profit calculation time
            }
            if (!Schema::hasColumn('user_copytradings', 'total_profit')) {
                $table->decimal('total_profit', 15, 2)->default(0)->after('last_profit'); // Total profits earned
            }
            if (!Schema::hasColumn('user_copytradings', 'current_balance')) {
                $table->decimal('current_balance', 15, 2)->default(0)->after('total_profit'); // Current balance
            }
            if (!Schema::hasColumn('user_copytradings', 'total_trades')) {
                $table->integer('total_trades')->default(0)->after('current_balance'); // Total trades copied
            }
            if (!Schema::hasColumn('user_copytradings', 'winning_trades')) {
                $table->integer('winning_trades')->default(0)->after('total_trades'); // Winning trades
            }
            if (!Schema::hasColumn('user_copytradings', 'profit_percentage')) {
                $table->decimal('profit_percentage', 8, 2)->default(0)->after('winning_trades'); // Overall profit percentage
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (!Schema::hasTable('user_copytradings')) {
            return;
        }

        Schema::table('user_copytradings', function (Blueprint $table) {
            $columns = [
                'started_at',
                'last_profit',
                'total_profit',
                'current_balance',
                'total_trades',
                'winning_trades',
                'profit_percentage'
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('user_copytradings', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
