<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTradingColumnsToUserPlansTable extends Migration
{
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		if (!Schema::hasTable('user_plans')) {
			return;
		}

		Schema::table('user_plans', function (Blueprint $table) {
			if (!Schema::hasColumn('user_plans', 'assets')) {
				$table->string('assets')->nullable()->after('last_growth');
			}
			if (!Schema::hasColumn('user_plans', 'type')) {
				$table->string('type')->nullable()->after('assets');
			}
			if (!Schema::hasColumn('user_plans', 'leverage')) {
				$table->string('leverage')->nullable()->after('type');
			}
			if (!Schema::hasColumn('user_plans', 'profit_earned')) {
				$table->decimal('profit_earned', 15, 2)->default(0)->after('leverage');
			}
			if (!Schema::hasColumn('user_plans', 'active')) {
				$table->string('active')->nullable()->after('profit_earned');
			}
			if (!Schema::hasColumn('user_plans', 'symbol')) {
				$table->string('symbol')->nullable()->after('active');
			}
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		if (!Schema::hasTable('user_plans')) {
			return;
		}

		Schema::table('user_plans', function (Blueprint $table) {
			$columns = ['assets', 'type', 'leverage', 'profit_earned', 'active', 'symbol'];
			foreach ($columns as $column) {
				if (Schema::hasColumn('user_plans', $column)) {
					$table->dropColumn($column);
				}
			}
		});
	}
}
