<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingUserColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'username')) {
                $table->string('username')->unique()->after('name');
            }
            if (!Schema::hasColumn('users', 'l_name')) {
                $table->string('l_name')->nullable()->after('username');
            }
            if (!Schema::hasColumn('users', 'currency')) {
                $table->string('currency')->nullable()->after('country');
            }
            if (!Schema::hasColumn('users', 'notify')) {
                $table->string('notify')->nullable()->after('currency');
            }
            if (!Schema::hasColumn('users', 'taxtype')) {
                $table->string('taxtype')->nullable()->after('notify');
            }
            if (!Schema::hasColumn('users', 'taxamount')) {
                $table->string('taxamount')->nullable()->after('taxtype');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['username', 'l_name', 'currency', 'notify', 'taxtype', 'taxamount']);
        });
    }
}
