<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class FixSchemaFromSqlDump extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $missingTables = [
            'adverts' => <<<'SQL'
CREATE TABLE `adverts` (
    `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `nickname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `min_limit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_limit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `limits` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `base` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quote` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_methods` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `completion_rate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
SQL,
            'loans' => <<<'SQL'
CREATE TABLE `loans` (
    `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user` int(11) DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `facility` varchar(255) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `purpose` longtext DEFAULT NULL,
  `income` varchar(255) DEFAULT NULL,
  `inv_duration` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `active` varchar(255) DEFAULT NULL,
    `activated_at` timestamp(3) NULL DEFAULT NULL,
    `last_growth` timestamp(3) NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
SQL,
            'orders_p2ps' => <<<'SQL'
CREATE TABLE `orders_p2ps` (
    `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `sender` bigint(20) UNSIGNED DEFAULT NULL,
  `receiver` bigint(20) UNSIGNED DEFAULT NULL,
  `order` varchar(255) DEFAULT NULL,
  `order_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `payment_status` varchar(20) DEFAULT NULL,
  `first_payment` varchar(20) DEFAULT NULL,
  `send` varchar(255) DEFAULT NULL,
  `receive` varchar(255) DEFAULT NULL,
    `screenshot` text DEFAULT NULL,
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
SQL,
            'tasks' => <<<'SQL'
CREATE TABLE `tasks` (
    `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(191) DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `designation` varchar(191) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
    `attch` varchar(191) DEFAULT NULL,
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
SQL,
            'migrations' => <<<'SQL'
CREATE TABLE `migrations` (
    `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
    `batch` int(11) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
SQL,
        ];

        foreach ($missingTables as $table => $sql) {
            if (!Schema::hasTable($table)) {
                DB::statement($sql);
            }
        }

        $missingColumns = [
            'activities' => [
                'user' => '`user` int(11) DEFAULT NULL',
                'ip_address' => '`ip_address` varchar(191) DEFAULT NULL',
                'device' => '`device` varchar(191) DEFAULT NULL',
                'browser' => '`browser` varchar(191) DEFAULT NULL',
                'os' => '`os` varchar(191) DEFAULT NULL',
            ],
            'admins' => [
                'token_2fa_expiry' => '`token_2fa_expiry` datetime DEFAULT current_timestamp()',
                'enable_2fa' => '`enable_2fa` varchar(191) NOT NULL DEFAULT \'disbaled\'',
                'token_2fa' => '`token_2fa` varchar(191) DEFAULT NULL',
                'pass_2fa' => '`pass_2fa` varchar(191) DEFAULT NULL',
                'password_token' => '`password_token` varchar(100) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'agents' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'assets' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'autologin_tokens' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'bnc_transactions' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'user_id' => '`user_id` bigint(20) UNSIGNED DEFAULT NULL',
                'deposit_id' => '`deposit_id` bigint(20) UNSIGNED DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'bot_trading_history' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'contents' => [
                'created_at' => '`created_at` datetime NOT NULL DEFAULT current_timestamp()',
                'updated_at' => '`updated_at` datetime NOT NULL DEFAULT current_timestamp()',
            ],
            'copytradings' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'total_profits' => '`total_profits` varchar(255) DEFAULT NULL',
                'button_name' => '`button_name` varchar(255) DEFAULT NULL',
                'active_days' => '`active_days` varchar(255) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'cp_transactions' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'crypto_accounts' => [
                'user_id' => '`user_id` bigint(20) UNSIGNED NOT NULL',
                'bnb' => '`bnb` float DEFAULT NULL',
                'ada' => '`ada` float DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'crypto_records' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'deposits' => [
                'signals' => '`signals` varchar(255) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'failed_jobs' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
            ],
            'faqs' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'images' => [
                'created_at' => '`created_at` datetime NOT NULL DEFAULT current_timestamp()',
                'updated_at' => '`updated_at` datetime NOT NULL DEFAULT current_timestamp()',
            ],
            'instruments' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'investments' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
                'profit_earned' => '`profit_earned` float DEFAULT NULL',
            ],
            'ipaddresses' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'kycs' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'user_id' => '`user_id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'market_prices' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'mt4_details' => [
                'account_name' => '`account_name` varchar(191) DEFAULT NULL',
                'reminded_at' => '`reminded_at` datetime DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'notifications' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'paystacks' => [
                'id' => '`id` int(11) NOT NULL',
                'created_at' => '`created_at` timestamp NOT NULL DEFAULT current_timestamp()',
                'updated_at' => '`updated_at` timestamp NOT NULL DEFAULT current_timestamp()',
            ],
            'personal_access_tokens' => [
                'tokenable_type' => '`tokenable_type` varchar(191) NOT NULL',
                'tokenable_id' => '`tokenable_id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'plan_categories' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'plan_plan_category' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
            ],
            'plans' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
                'tag' => '`tag` varchar(255) DEFAULT NULL',
                'deleted_at' => '`deleted_at` timestamp NULL DEFAULT NULL',
            ],
            'settings_conts' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'fee' => '`fee` float DEFAULT 0',
                'btc' => '`btc` varchar(20) NOT NULL DEFAULT \'enabled\'',
                'eth' => '`eth` varchar(20) NOT NULL DEFAULT \'enabled\'',
                'ltc' => '`ltc` varchar(20) NOT NULL DEFAULT \'enabled\'',
                'link' => '`link` varchar(20) NOT NULL DEFAULT \'enabled\'',
                'bnb' => '`bnb` varchar(191) NOT NULL DEFAULT \'enabled\'',
                'aave' => '`aave` varchar(250) DEFAULT \'enabled\'',
                'usdt' => '`usdt` varchar(250) NOT NULL DEFAULT \'enabled\'',
                'bch' => '`bch` varchar(191) NOT NULL DEFAULT \'enabled\'',
                'xlm' => '`xlm` varchar(191) NOT NULL DEFAULT \'enabled\'',
                'xrp' => '`xrp` varchar(191) NOT NULL DEFAULT \'enabled\'',
                'ada' => '`ada` varchar(191) NOT NULL DEFAULT \'enabled\'',
                'currency_rate' => '`currency_rate` int(11) DEFAULT NULL',
                'minamt' => '`minamt` int(11) DEFAULT NULL',
                'use_transfer' => '`use_transfer` tinyint(1) DEFAULT 1',
                'min_transfer' => '`min_transfer` int(11) DEFAULT 0',
                'purchase_code' => '`purchase_code` varchar(191) DEFAULT \'xxxxxx\'',
                'transfer_charges' => '`transfer_charges` int(11) DEFAULT 0',
                'bnc_secret_key' => '`bnc_secret_key` varchar(191) DEFAULT NULL',
                'bnc_api_key' => '`bnc_api_key` varchar(191) DEFAULT NULL',
                'flw_secret_hash' => '`flw_secret_hash` varchar(191) DEFAULT NULL',
                'flw_secret_key' => '`flw_secret_key` varchar(191) DEFAULT NULL',
                'flw_public_key' => '`flw_public_key` varchar(191) DEFAULT NULL',
                'local_currency' => '`local_currency` varchar(20) DEFAULT NULL',
                'commission_p2p' => '`commission_p2p` float DEFAULT NULL',
                'enable_p2p' => '`enable_p2p` varchar(20) DEFAULT NULL',
                'base_currency' => '`base_currency` varchar(20) DEFAULT NULL',
                'telegram_bot_api' => '`telegram_bot_api` varchar(192) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'signals' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'terms_privacies' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'testimonies' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'themes' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'tp__transactions' => [
                'user_plan_id' => '`user_plan_id` int(11) DEFAULT NULL',
                'leverage' => '`leverage` int(11) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'trades' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'trading_bots' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'user_bot_investments' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'user_copytradings' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'ratings' => '`ratings` varchar(255) DEFAULT NULL',
                'equity' => '`equity` varchar(255) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'user_plans' => [
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'user_signals' => [
                'asset' => '`asset` varchar(255) DEFAULT NULL',
                'amount' => '`amount` float DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'users' => [
                'kyc_id' => '`kyc_id` int(11) DEFAULT NULL',
                's_currency' => '`s_currency` varchar(255) NOT NULL DEFAULT \'USD\'',
                'notify_status' => '`notify_status` varchar(33) DEFAULT NULL',
                'cstatus' => '`cstatus` varchar(191) DEFAULT NULL',
                'userupdate' => '`userupdate` text DEFAULT NULL',
                'tradetype' => '`tradetype` varchar(255) NOT NULL DEFAULT \'Profit\'',
                'numberoftrades' => '`numberoftrades` int(11) NOT NULL DEFAULT 2',
                'assign_to' => '`assign_to` varchar(191) DEFAULT NULL',
                'swift_code' => '`swift_code` varchar(191) DEFAULT NULL',
                'usdt_address' => '`usdt_address` varchar(191) DEFAULT NULL',
                'trades' => '`trades` varchar(255) DEFAULT NULL',
                'signals' => '`signals` varchar(255) DEFAULT NULL',
                'remember_token' => '`remember_token` varchar(100) DEFAULT NULL',
                'withdrawotp' => '`withdrawotp` varchar(191) DEFAULT NULL',
                'sendotpemail' => '`sendotpemail` varchar(191) NOT NULL DEFAULT \'No\'',
                'sendpromoemail' => '`sendpromoemail` varchar(191) NOT NULL DEFAULT \'Yes\'',
                'sendinvplanemail' => '`sendinvplanemail` varchar(191) NOT NULL DEFAULT \'Yes\'',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
                'signal_status' => '`signal_status` varchar(255) NOT NULL DEFAULT \'off\'',
                'plan_status' => '`plan_status` varchar(11) NOT NULL DEFAULT \'off\'',
                'user_signal' => '`user_signal` varchar(255) DEFAULT NULL',
                'user_plan_upgade' => '`user_plan_upgade` varchar(225) DEFAULT NULL',
                'withdrawal_code' => '`withdrawal_code` varchar(22) NOT NULL DEFAULT \'on\'',
                'user_withdrawalcode' => '`user_withdrawalcode` varchar(255) DEFAULT NULL',
                'progress' => '`progress` int(11) NOT NULL DEFAULT 0',
                'wallet_connected' => '`wallet_connected` int(11) DEFAULT NULL',
            ],
            'wallets' => [
                'id' => '`id` bigint(20) UNSIGNED NOT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'wdmethods' => [
                'charges_amount' => '`charges_amount` varchar(191) DEFAULT NULL',
                'charges_type' => '`charges_type` varchar(191) DEFAULT NULL',
                'img_url' => '`img_url` text DEFAULT NULL',
                'bankname' => '`bankname` varchar(191) DEFAULT NULL',
                'account_name' => '`account_name` varchar(191) DEFAULT NULL',
                'account_number' => '`account_number` varchar(191) DEFAULT NULL',
                'swift_code' => '`swift_code` varchar(191) DEFAULT NULL',
                'wallet_address' => '`wallet_address` text DEFAULT NULL',
                'barcode' => '`barcode` text DEFAULT NULL',
                'network' => '`network` varchar(191) DEFAULT NULL',
                'methodtype' => '`methodtype` varchar(191) DEFAULT NULL',
                'defaultpay' => '`defaultpay` varchar(20) DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
            'withdrawals' => [
                'columns' => '`columns` varchar(191) DEFAULT NULL',
                'paydetails' => '`paydetails` text DEFAULT NULL',
                'created_at' => '`created_at` timestamp NULL DEFAULT NULL',
                'updated_at' => '`updated_at` timestamp NULL DEFAULT NULL',
            ],
        ];

        foreach ($missingColumns as $table => $columns) {
            if (!Schema::hasTable($table)) {
                continue;
            }

            foreach ($columns as $column => $definition) {
                if (!Schema::hasColumn($table, $column)) {
                    DB::statement("ALTER TABLE `$table` ADD COLUMN $definition");
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        foreach (['adverts', 'loans', 'orders_p2ps', 'tasks', 'migrations'] as $table) {
            if (Schema::hasTable($table)) {
                Schema::drop($table);
            }
        }
    }
}
