<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UpdateAdminsAddressToJson extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('admins') && Schema::hasColumn('admins', 'address')) {
            $indexes = DB::select("SHOW INDEX FROM `admins` WHERE Key_name = 'admins_address_unique'");
            if (!empty($indexes)) {
                DB::statement('ALTER TABLE `admins` DROP INDEX `admins_address_unique`');
            }
            DB::statement('ALTER TABLE `admins` MODIFY `address` TEXT NULL');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('admins') && Schema::hasColumn('admins', 'address')) {
            DB::statement('ALTER TABLE `admins` MODIFY `address` VARCHAR(255) NULL');
            $indexes = DB::select("SHOW INDEX FROM `admins` WHERE Key_name = 'admins_address_unique'");
            if (empty($indexes)) {
                DB::statement('ALTER TABLE `admins` ADD UNIQUE `admins_address_unique` (`address`)');
            }
        }
    }
}
