<?php

namespace Database\Seeders;

use App\Models\Admin;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $email = env('ADMIN_EMAIL', 'admin@example.com');
        $password = env('ADMIN_PASSWORD', 'password');
        $firstName = env('ADMIN_FIRST_NAME', 'Admin');
        $lastName = env('ADMIN_LAST_NAME', 'User');

        Admin::updateOrCreate(
            ['email' => $email],
            [
                'firstName' => $firstName,
                'lastName' => $lastName,
                'password' => Hash::make($password),
                'status' => 'active',
                'type' => 'super',
            ]
        );
    }
}
